""""""
import numpy as np
from sklearn.neural_network import MLPClassifier as MLP


class ForgettingDV:
    """Estimate data value with forgetting events."""

    def __init__(self, hidden_layer_sizes=(100), X_base=None, y_base=None, num_epochs=100):
        """"""
        self.hidden_layer_sizes = hidden_layer_sizes

        # Init model with warm start
        self.model = MLP(hidden_layer_sizes=hidden_layer_sizes, activation='relu', max_iter=1, warm_start=True)

        self.X_base = X_base
        self.y_base = y_base

        self.num_epochs = num_epochs

    def predict_dv(self, X, y, sct=None, plot_every=5):
        """"""
        forgetting_stats = np.zeros_like(y)
        prev_acc = np.zeros_like(y)

        for epoch in range(self.num_epochs):
            self.model.fit(X, y) # model initialized with warm start and fits for one epoch only

            for i in range(len(y)):
                y_pred = self.model.predict(X[i].reshape(1, -1))
                acc = 1 if y[i] == y_pred else 0

                if acc < prev_acc[i]:
                    forgetting_stats[i] += 1

                prev_acc[i] = acc

            if sct is not None and epoch % plot_every == 0:
                sct.add_boundary(self.model.predict)
                sct.show(title="Epoch: "+str(epoch))

        forgetting_stats = forgetting_stats / self.num_epochs
        return forgetting_stats
