""""""
import numpy as np
from tqdm import tqdm
from sklearn.neural_network import MLPClassifier as MLP


class EnsembleOOD:
    def __init__(self, x_train, y_train, x_valid, y_valid,
                 arc=100, max_iter=1000,
                 num_models=25, epochs=50):
        """"""
        self.arc = arc
        self.max_iter = max_iter

        self.x_train = x_train
        self.y_train = y_train
        self.x_valid = x_valid
        self.y_valid = y_valid

        self.num_models = num_models
        self.epochs = epochs

        self.models = [MLP(hidden_layer_sizes=self.arc, activation='relu', max_iter=self.max_iter)
                       for _ in range(num_models)]
        self._fit()

    def _fit(self):
        """"""
        acc = []

        for model in tqdm(self.models):
            model.fit(self.x_train, self.y_train)
            acc.append(model.score(self.x_valid, self.y_valid))

        print("Average accuracy after fitting:", np.mean(acc), "std ", np.std(acc))

    def predict_dv(self, X):
        """Returns data values using the data valuator model."""
        predictions = np.array([model.predict(X) for model in self.models])
        std = np.std(predictions, axis=0)
        return std

    def predict(self, X):
        """Returns predictions using the predictor model."""
        predictions = np.array([model.predict(X) for model in self.models])
        mean = np.mean(predictions, axis=0)
        return np.round(mean)