# Generalized Logit Adjustment: Calibrating Fine-tuned Models by Removing Label Bias in Foundation Models

This repository contains code for the Generalized Logit Adjustment (GLA).

**TLDR**: We improve the performance of fine-tuned models by removing label bias of  foundation models.

### Install dependencies

```bash
conda env create
conda activate gla
```

### Add directory to PYTHONPATH:

```bash
cd GLA.public
export PYTHONPATH="$PYTHONPATH:$PWD"
```

### Prepare ImageNet

- (Skip if already downloaded) Download the dataset from the [official website](https://image-net.org/index.php) and extract the training and validation sets to `${ANY_PATH_YOU_PREFER}/imagenet/images`. The directory structure should look like:

```
imagenet/
|–– images/
|   |–– train/ # contains 1,000 folders like n01440764, n01443537, etc.
|   |–– val/
```

- Create data directory and create symbolic links.

```bash
export DATA_LOCATION=~/data
cd $DATA_LOCATION
mkdir imagenet
ln -s ${ANY_PATH_YOU_PREFER}/imagenet/images imagenet
```

### Download pre-trained models

- Download the available zero-shot and fine-tuned models (CLIP ViT-B/16) from [WiSE-FT](https://drive.google.com/drive/folders/1f56kjpRKPiNSaUxNDtETEDRkbDkZnpCQ?usp=sharing) to the directory `./models`. The directory structure should look like:

```
models/
   |–– zeroshot.pt 
   |–– checkpoint_10.pt
   |–– q.pt # already exists
```
### Run GLA

- Compare the top-1 and breakdown performance of (1) zero-shot, (2) fine-tuned, (3) WiSE-FT, and (4) our GLA models.

```
python src/gla.py --load=models/zeroshot.pt,models/checkpoint_10.pt,models/q.pt
```






