# An Adaptive Algorithm for Bilevel Optimization on Riemannian Manifolds
This repository is the implementation of the algorithms and experiments in the paper "An Adaptive Algorithm for Bilevel Optimization on Riemannian Manifolds".

## Initial Setup

To get started with the code, follow these steps:

1. **Clone the repository**:
   ```bash
   git clone https://github.com/andyjm3/rhgd.git
   cd rhgd
   touch __init__.py
   ```
    Or manually download the [RHGD repository](https://github.com/andyjm3/rhgd) and create an `__init__.py` file inside the rhgd folder to make it a callable package.

2. **Download the data**:

    Place the downloaded AFEW data into the data folder. You can find the AFEW data in the [SPDNet repository](https://github.com/zhiwu-huang/SPDNet/blob/master/data/afew/spddb_afew_train_spd400_int_histeq.mat).

## Introduction
This code can be run in Python 3.8.10. The specific implementation of our algorithm **AdaRHD** is in the `src` folder.

- `src/AdaRHD_optimizer.py`: includes a function for a single iteration step of our algorithm.
- `src/AdaRHD_utils.py`: includes various utility functions, such as gradient descent (GD) and tangent space conjugate gradient (CG) methods for subproblem optimization.
- `src/AdaRHD_manifolds.py`: includes definitions for all manifold classes used in the experiments.

## How to get the results
To reproduce the results reported in the paper, you can run the corresponding code as follows:

- `run_simple_spd_gr_RHGD.py`,`run_simple_spd_gr_AdaRHD.py`：run to obtain results for the subsection _*Simple problem*_.
- `run_hyrep_spd_RHGD.py`,`run_hyrep_spd_AdaRHD.py`: run to obtain results for the subsection _*Shallow hyper-representation for regression*_.
- `run_deep_hyrep_spd_RHGD.py`,`run_deep_hyrep_spd_AdaRHD.py`: run to obtain results for the subsection _*Deep hyper-representation for classification*_.
- `run_deep_hyrep_spd_robust_RHGD.py`,`run_deep_hyrep_spd_robust_AdaRHD.py`: run to obtain results for the subsection _*Robustness analysis*_.
- `run_robust_KM_RHGD.py`,`run_robust_KM_AdaRHD.py`,`run_robust_mle_RHGD.py`,`run_robust_mle_AdaRHD.py`: run to obtain results for the subsection _*Robust optimization on manifolds*_.

After running the above scripts, the corresponding charts can be generated via the `.ipynb` notebook file in the `plot_fig` folder.

## Citation
If you want to reference our paper in your research, please consider citing us by using the following BibTeX:

``` bib
@article{shi2025adaptive,
  title={An Adaptive Algorithm for Bilevel Optimization on Riemannian Manifolds},
  author={Shi, Xu and Xiao, Rufeng and Jiang, Rujun},
  journal={arXiv preprint arXiv:2504.06042},
  year={2025}
}
```

If you have any questions, please contact us.