## concept learning
# Baseline
python AwA2_main_v2.py --name AwA2_baseline_concept100 --num_concept 100 --epoch 5 --save_step 1 --offset 0 --gpu 1 --batch_size 250


# Baseline + score l2
python AwA2_main_v2.py --name AwA2_baseline_msp_coeff1 --score msp --coeff_score 1 --bs 350 --epoch 10 --gpu 5 --offset 0
python AwA2_main_v2.py --name AwA2_baseline_msp_coeff1_ood --score msp --coeff_score 1 --bs 200 --epoch 10 --gpu 5 --offset 0 --ood

# Baseline + separability
python AwA2_main_v2.py --epoch 4 --name AwA2_baseline_separability_perclass_coeff1 --separability --coeff_concept 10 --coeff_separa 1 --offset 0 --val_step 1 --save_step 1 --bs 200 --gpu 0

# Ours (Baseline + score l2 + separability)
python AwA2_main_v2.py --epoch 4 --name AwA2_ours --ood --score msp --separability --coeff_concept 10 --coeff_separa 1 --coeff_score 2 --bs 200 --offset 0 --gpu 3

# Ours with global multivariate separability
python AwA2_main_v2.py --feat_l2 --coeff_feat 0.1 --score msp --coeff_score 1 --separability --coeff_separa 10 --ood --name AwA2_coher10_msp1_feat0.1_separa_multiv_evd_coeff10_oodrandom_concept70 --epoch 14 --offset 0 --gpu 7

# separability between "detected" ID vs OOD concept scores
python AwA2_main_v2.py --coeff_score 0 --separability --coeff_separa 10 --ood --name AwA2_coher10_separaMSP_multiv_coeff10_concept100 --score msp --num_concept 100 --epoch 8 --offset 0 --gpu 7


# Ours with 100 concepts
# ODIN
python AwA2_main_v2.py --coeff_score 1e+8 --ood --feat_l2 --coeff_feat 0.1 --separability --coeff_separa 50 --ood --name AwA2_coher10_odin1e8_feat0.1_separaODIN_multiv_coeff50_concept100 --score odin --num_concept 100 --epoch 8 --offset 0 --gpu 1 --batch_size 64

# Energy
python AwA2_main_v2.py --coeff_score 1 --ood --feat_l2 --coeff_feat 0.1 --separability --coeff_separa 50 --ood --name AwA2_coher10_energy1_feat0.1_separaEnergy_multiv_coeff50_concept100 --score energy --num_concept 100 --epoch 2 --offset 8 --save_step 1 --val_step 1 --gpu 2


## evaluation
# cifar10
python AwA2_eval.py --logdir results --name AwA2_baseline_energy --result_dir results/AwA2_baseline_energy --out_data cifar10 --out_data_dim 32 --gpu 7 --score Energy

python AwA2_eval.py --logdir results --name AwA2_baseline_separability_perclass_coeff0.5 --result_dir results/AwA2_baseline_separability_perclass_coeff0.5/ --out_data cifar10 --out_data_dim 32 --gpu 0 --score MSP --visualize --separate

# SUN
python AwA2_eval.py --logdir results --name AwA2_baseline --result_dir results/AwA2_baseline --out_data SUN --gpu 2 --score Energy


# explain
python AwA2_explain.py --gpu 0 --log results --name AwA2_coher10_energy1_feat0.1_separaEnergy_multiv_coeff50_concept100 --out_data SUN

