# Incentivized Collaborative Learning: Architectural Design and Insights

We greatly appreciate your assistance with the review. Your expertise and time are immensely valuable.  


## Requirements

- Requires Python 3.9 or higher

- see requirements.txt

  

## Instruction for FL

- source codes are in the subfolder "ICL-FL"

- Global hyperparameters are configured in config.yml

- Hyperparameters can be found at process_command.py in utils.py

- Example: Train CIFAR10 dataset with CNN, 0.1 active rate, 100 clients, label-flipping, 0.1 Byzantine client ratio, ICL, pricing plan 1

  ```ruby
  python train_classifier_fl.py --control_name CIFAR10_cnn_0.1_100_labelflipping_0.1_icl_1
  ```

- Example: Train CINIC10 dataset with CNN, 0.1 active rate, 100 clients, random modification, 0.2 Byzantine client ratio, ICL, pricing plan 2

  ```ruby
  python train_classifier_fl.py --control_name CINIC10_cnn_0.1_100_random_0.2_icl_2
  ```

- Example: Train CIFAR10 dataset with CNN, 0.1 active rate, 100 clients, random modification, 0 Byzantine client ratio, FedAvg

  ```ruby
  python train_classifier_fl.py --control_name CIFAR10_cnn_0.1_100_random_0_fedavg
  ```



## Instruction for AL 

- source codes are in the subfolder "ICL-AL"



## Instruction for MAB 

- source codes are in the subfolder "ICL-MAB"





