# Public ADME Dataset Example

This directory contains data and code to run the example for the public ADME dataset (Appendix Section D. Benchmark With Public Dataset) from the paper. You will need to instantiate the `ADME_example/Project.toml` first as a Julia project, making sure that `IBMDPDesigns` refers to the package in the root directory. The easiest way to do that is to open a Julia REPL, navigate to this directory. E.g. use `;` to enter shell mode, then `cd ADME_example`, then enter backspace to return to the REPL, then enter `]` to enter the Package manager mode, and run `activate .` and `dev ../` followed by `instantiate` to ensure the project is successfully instantiated.

After the project is set up, to run the examples from the paper, please run from the root directory: `julia --project=ADME_example/ ADME_example/run.jl`. The Julia script may take several command line arguments:

```
Usage:
    julia run.jl [options]
    
Options:
    -c, --config <file>   Configuration file to use (default: config.jl)
    --data <file>         Data CSV file for automatic config generation (one-step mode)
    --name <name>         Experiment name (required with --data)
    -s, --sample <idx>    Run analysis for a specific sample index
    -e, --ensembles <n>   Number of ensemble runs (default: from config)
    -t, --tau <values>    Comma-separated tau values (default: from config)
    -o, --output <dir>    Output directory (overrides config)
    -h, --help            Show help message

Examples:
    julia run.jl                                  # Run with default config
    julia run.jl -c user_config.jl                # Use custom config
    julia run.jl -c materials_config.jl -e 50     # Custom config with 50 ensembles
    julia run.jl -s 1 -t 0.6,0.9                  # Run sample 1 with specific tau values
```

The parameters including costs for assays used in the paper are stored in `config.jl`, and the data may be found in `data.csv`. Output is generated in `results/` directory. The following files are generated per run:

- `sample_metadata.csv` - Initial state and configuration
- `ensemble_results_tau_X.csv` - Detailed results for each tau value
- `ensemble_Pareto_front_X.png` - Pareto front visualization
- `plt_hist_belief_X.png` - Histogram of action frequencies
- `hist_plot_set/` - Individual threshold histograms
- `analysis_summary.csv` - Summary statistics across all samples
