# CNS Example

This directory contains data and code to run the example for CNS data (brain penentration assays) from the paper. You will need to instantiate the `CNS_example/Project.toml` first as a Julia project, making sure that `IBMDPDesigns` refers to the package in the root directory. The easiest way to do that is to open a Julia REPL, navigate to this directory. E.g. use `;` to enter shell mode, then `cd CNS_example`, then enter backspace to return to the REPL, then enter `]` to enter the Package manager mode, and run `activate .` and `dev ../` followed by `instantiate` to ensure the project is successfully instantiated.

After the project is set up, to run the examples from the paper, please run from the root directory: `julia --project=CNS_example/ CNS_example/run.jl`. The Julia script may take several command line arguments:

```
Usage:
    julia run.jl                        # Run all molecules with 10 ensembles, tau=0.9
    julia run.jl --m 2                  # Run single molecule 2 with 10 ensembles
    julia run.jl --m 3 -e 20            # Run molecule 3 with 20 ensembles
    julia run.jl --e 50                 # Run all molecules with 50 ensembles
    julia run.jl --t 0.6,0.9            # Run with tau values 0.6 and 0.9
    julia run.jl -m 1 -e 50 -t 0.6,0.9  # Run molecule 1, 50 ensembles, tau 0.6 and 0.9
```

The parameters including costs for assays used in the paper are stored in `config.jl`, and the data may be found in `data/multitier.csv`. Output is generated in `results/representative_molecules_fixed` directory. A guide to the output format is below:

```
representative_molecules_fixed/
├── Scenario1_Low_kpuu_High_PgP_High_BCRP/
│   ├── ensemble_Pareto_front_0.9.png      # Pareto front with N_i annotations
│   ├── plt_hist_belief_0.9.png            # Frequency histogram
│   ├── action_set_legend_0.9.png          # Action set legend
│   ├── ensemble_results_tau_0.9.csv       # Detailed results
│   ├── scenario_metadata.csv              # Scenario information
│   └── hist_plot_set/                     # Individual threshold plots
│       └── uncertainty_ensemble_action_set_belief_0.9_*.png
├── Scenario2_Low_kpuu_High_PgP_Low_BCRP/
├── Scenario3_High_kpuu_Low_PgP_Low_BCRP/
├── Scenario4_Low_kpuu_Low_PgP_High_BCRP/
└── compare_plots_enforced.png             # Cross-scenario comparison
```
