module IBMDPDesigns

# external dependencies
using DataFrames, Plots

# exported objects
export front, plot_front, plot_dict, save_figure
export make_labels, plot_evals

# make Pareto fronts
include("fronts.jl")

# experimental designs
include("MDP/GenerativeDesigns.jl")

include("ValueIteration/ValueIteration.jl")
include("Utilities/Utilities.jl")

export value_iteration_analysis, similarity_based_value_iteration, theoretical_value_iteration
export setup_mdp_framework, run_mdp_analysis
export gradient_bar, make_labels_modi, cost_bias_tuple
export load_synthetic_data, setup_ceed_configuration, setup_default_plotting_options
export create_experiments_dict, setup_enhanced_sampler, setup_solver
export find_project_data_directory
export ensemble_Vis, IBMDP_single_state_init, IBMDP_multiple_state_init_run

end