
## Installing Dependencies
Use virtual environment tools (e.g miniconda) to install packages and run experiments\
python>=3.6\
[pytorch](https://pytorch.org)

## Code Organization

The code is organized as follows:\
- LSTM (The code for LSTM is based on [this code base](https://github.com/deeplearningathome/pytorch-language-model).)
- ResNet
- VGG
- CNN (here we have also the code for the sensitivity analysis)
- FNN (here we have also the code for the sensitivity analysis)
- Compare_Pflug
- Regressions (here we have also the code for the sensitivity analysis)
- Histograms

## Reproducing experiments
To reproduce the experiments for LSTM/ResNet/VGG/CNN/FNN
```
sh LSTM/run_experiments_splitsgd.sh
sh ResNet/run_experiments.sh
sh VGG/run_experiments.sh
sh CNN/run_experiments.sh
sh FNN/run_experiments.sh
```

To reproduce the experiments for the comparison with the Pflug Diagnostic, run the R files in the Compare_Pflug folder
- Compare_Pflug.R is the main file
- Eyeball Stationarity.R for creating the red horizontal bands
- Code_Boxplots.R to make the plots

To reproduce the experiments for linear and logistic regressions, run the R files in the Regressions folder 
- Code_Regressions.R is the file for Figure 4
- Sensitivity_Analysis_Regressions.R is the sensitivity analysis in Figure 6

To reproduce the histograms, run the R file Histograms.R in the Histograms folder

