**# Supplemental Material: MLZero and MAAB**
This repository contains supplemental material for our work on MLZero and MAAB (Machine learning Agent Benchmark).
**## Repository Structure**
The repository consists of two main folders:
1. **AutoMLAgent**: Contains our proposed method MLZero. Note that while the folder is named as AutoMLAgent that may have same name with existing work, the actual method is MLZero (renamed due to a conflict with existing work) NOT AutoMLAgent.
2. **maab**: Contains our proposed benchmark with datasets and evaluation tools for machine learning agents.

**## Important Setup Notes**
**### Directory Structure**
- Please place both folders under `/media/agent/` as there are some hardcoded evaluation paths in maab.
 ```
 /media/agent/AutoMLAgent/
 /media/agent/maab/
 ```

**## Usage**

Please refer to the README files in each folder for detailed instructions:
- `/media/agent/AutoMLAgent/README.md` - For MLZero specific details
- `/media/agent/maab/README.md` - For benchmark details and evaluation procedures

Note: To use MAAB, please install AutoMLAgent(MLZero) in the conda environment named "agent".

**## Using MLZero with MAAB**

When evaluating MLZero on the MAAB benchmark, use the agent named "mlzero" to use the default configuration of MLZero.

**## Known Issues**

1. Some evaluation code in MAAB contains hardcoded paths, which is why the specific directory structure and environment name are required. This will be refactored in future releases.

2. If you encounter any dependency conflicts or installation issues, try using *uv pip* instead.
