# Condensed: BGE Auto Embedder

Summary: This tutorial demonstrates the implementation of BGE Auto Embedder, focusing on text embedding generation for information retrieval tasks. It provides code examples for initializing and using the FlagAutoModel to encode queries and passages, with specific implementation details for model configuration through EmbedderConfig dataclass. The tutorial covers essential techniques for customizing embedding models, including pooling methods, device allocation, and query instruction formatting. It helps with tasks involving text embedding generation, similarity scoring, and model customization, supporting multiple embedding model families (BGE, E5, GTE, SFR). Key features include flexible model initialization, query/corpus encoding, and configuration management through a standardized interface.

*This is a condensed version that preserves essential implementation details and context.*

Here's the condensed tutorial focusing on essential implementation details:

# BGE Auto Embedder Implementation Guide

## Key Implementation Details

```python
from FlagEmbedding import FlagAutoModel

# Initialize model
model = FlagAutoModel.from_finetuned(
    'BAAI/bge-base-en-v1.5',
    query_instruction_for_retrieval="Represent this sentence for searching relevant passages: ",
    devices="cuda:0"  # Uses all GPUs if not specified
)

# Basic Usage
queries = ["query 1", "query 2"]
corpus = ["passage 1", "passage 2"]

q_embeddings = model.encode_queries(queries)
p_embeddings = model.encode_corpus(corpus)
scores = q_embeddings @ p_embeddings.T
```

## Critical Configurations

The `EmbedderConfig` dataclass defines model configuration:
```python
@dataclass
class EmbedderConfig:
    model_class: Type[AbsEmbedder]
    pooling_method: PoolingMethod
    trust_remote_code: bool = False
    query_instruction_format: str = "{}{}"
```

## Model Customization Requirements

To implement custom models, define these essential parameters:

1. Model type (encoder/decoder)
2. Pooling method (CLS token/mean pooling/last token)
3. Remote code trust setting
4. Query instruction format

## Best Practices

- Verify model compatibility with `AUTO_EMBEDDER_MAPPING`
- Configure appropriate pooling method for your use case
- Set correct device allocation based on hardware
- Use query instructions for retrieval tasks when applicable

## Supported Models
- BGE series
- E5
- GTE
- SFR
- Other compatible embedding models through `AUTO_EMBEDDER_MAPPING`

Installation:
```python
pip install FlagEmbedding
```