# Inverse Optimization Latent Variable Models for Route Problems

This repository accompanies the paper:  
**"Inverse Optimization Latent Variable Models for Learning Costs Applied to Route Problems."**

## Overview

We provide code to run experiments on four datasets:

1. `main_spp_synthetic.py`
2. `main_spp_ship.py`
3. `main_spp_cabspot.py`
4. `main_tsp_tsplib.py`

---

## Common Parameters

These parameters are shared across all experiments:

| Parameter     | Description                                                                 | Typical Values        |
|---------------|-----------------------------------------------------------------------------|-----------------------|
| `method`      | Model to use: `IOLVM`, `VAE`, or `PO` (when available)                      | `IOLVM`, `VAE`, `PO`  |
| `eps`         | Variance of the perturbation used during training (see ε in the paper)      | `0.05`                |
| `BS`          | Batch size                                                                  | `200` to `250`        |
| `beta`        | Weight for the KL divergence term in the loss                               | `0.01` to `1.0`       |
| `seed_n`      | Random seed                                                                 | See default values    |
| `latent_dim`  | Latent space dimensionality                                                 | See paper appendix    |
| `n_epochs`    | Number of training epochs                                                   | See default values   |
| `lr`          | Learning rate                                                               | See paper appendix   |

---

## Experiment-Specific Parameters

### `main_spp_synthetic.py`

| Parameter | Description                                                                 |
|-----------|-----------------------------------------------------------------------------|
| `mult`    | Choose between datasets with a single (`0`) or multiple (`1`) source/target nodes |

---

### `main_tsp_tsplib.py`

| Parameter    | Description                                                                 |
|--------------|-----------------------------------------------------------------------------|
| `dim_X`       | Number of hidden features used to generate edge costs (e.g., `3` or `50`)  |
| `graph_data`  | Dataset name or configuration for the TSPLIB instance (burma14 or bayg29)  |
| `N_train`     | Number of training samples                            (see paper, 2400, 1000 or 10000)          |

---

For detailed configurations and parameter tuning, please refer to the appendix of the paper.
