# IMITATION LEARNING

## Docker
```
sudo docker run --name <NAME> -it --gpus all -v data:/opt/data -v code:/opt/ml --shm-size=64gb IMAGE
```
## EXPERT (Sumo)
```
python3 prog_caller.py --proc EXPERT --exec-path <PATH> --rule-based --num-eps 200 --maxsteps 10000 --sumo --controller TravelAssistUnsafe --randomization-env --rand-num-vehicles 0 20 --img-height 100 --img-width 50 --bev-size 50 --bevoffsetx 10 --bevoffsety 0 --rawdata-path <PATH> --new-rand-eps 4 --initials <INITIALS> --milestone <MILESTONE> --task <TASK> --record-data --LaneIDSensor --vulkan
```

## PREPROCESS
```
python3 prog_caller.py --proc PREPROCESS --rawdata-path <PATH> --processeddata-path <PATH> --sim-steptime 20 --pose-steptime 500 --num-poses 5 --add-lane-changes 5 --car-network --multiprocess --initials <INITIALS> --milestone <MILESTONE> --task <TASK> --compress --compresseddata-path <PATH> --num-processes 64
```

## TRAIN
```
python3 prog_caller.py --proc TRAIN --training-df-path <PATH> --training-image-path <PATH> --validation-df-path <PATH> --validation-image-path <PATH> --img-height 100 --img-width 50 --algo BC --bezier --travelassist-pred --residual --lr-bc 0.001 --car-network --base-model transformer --track --save-model
```

## Lightning Training
```
python3 prog_caller.py --proc LIGHTNING --training-df-path <PATH>  --training-image-path <PATH> --validation-df-path <PATH> --validation-image-path <PATH> --img-height 100 --img-width 50 --algo BC --bezier --travelassist-pred --base-model transformer --num-gpus 8 --num-workers 4 --batch-size 256 --residual --lr-bc 0.0001 --track
```
## INFERENCE
```
python3 prog_caller.py --proc INFERENCE --infer-type Online --exec-path <PATH-TO-EXEC> --travelassist-pred --algo BC --model-path <PATH-TO-MODELS> --img-height 100 --img-width 50 --sumo --controller TravelAssistUnsafe --maxstep 20000 --model-name <MODEL-NAME>
```

## Randomization
To control and allow randomization of each vtype, we have a copy of the original in the scenedata folder, and will modify the vTypes.add.xml file in the simulation directory. Make sure to have each vType available in your projectsetting.json file, they are as follows:    
"VTypes": [
      "vTypeBase",
      "vTypeFast",
      "vTypeSlow",
      "vTypeAgressive",
      "vTypeImperfect"
    ],
## SWEEP
```
wandb sweep --project <PROJECT_NAME> --entity <ENTITY_NAME> sweep.yaml
<CUDA_VISIBLE_DEVICE> wandb agent <SWEEP_ID> <NUM_OF_RUNS>
```
