#!/bin/bash -l
#SBATCH --job-name="swarm_cifar"
#SBATCH --mail-type=ALL
#SBATCH --mail-user=
#SBATCH --time=01:00:00
#SBATCH --nodes=4
#SBATCH --ntasks-per-core=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=12
#SBATCH --partition=normal
#SBATCH --constraint=gpu
#SBATCH --hint=nomultithread
#SBATCH --account=<account>


export OMP_NUM_THREADS=$SLURM_CPUS_PER_TASK
export MPICH_RDMA_ENABLED_CUDA=1

module load daint-gpu cray-python PyTorch
module load intel
source <path-to-venv>/venv/bin/activate

srun python worker_temp.py --dataset-name cifar10 --average-epochs 75 --virtual-epoch-num 200 --batch-size 256 --lr 0.1 --log-interval 10 --weight-decay 0.0005 --local-updates 2 --quantize

