#!/bin/bash -l
#SBATCH --job-name="swarmsgd"
#SBATCH --mail-type=ALL
#SBATCH --mail-user=
#SBATCH --time=20:00:00
#SBATCH --nodes=32
#SBATCH --ntasks-per-core=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=12
#SBATCH --partition=normal
#SBATCH --constraint=gpu
#SBATCH --hint=nomultithread
#SBATCH --account=<account>


export OMP_NUM_THREADS=$SLURM_CPUS_PER_TASK
export MPICH_RDMA_ENABLED_CUDA=1

module load daint-gpu cray-python PyTorch
module load intel
source <path-to-venv>/venv/bin/activate


srun python worker_temp.py --dataset-name imagenet \
    --average-epochs 8 --virtual-epoch-num 50  --batch-size 256 --lr 1 \
    --log-interval 10 --weight-decay 0.0001 --local-updates 2 \
    --save-model --everyone-save --quantize

