#!/bin/bash

INSTALL_DIR=$1

if [ -z "$INSTALL_DIR" ]
then
    echo "Please provide a path to install the module."
    exit 1;
fi

# Setup PrgEnv
module swap PrgEnv-cray PrgEnv-gnu
module load craype-accel-nvidia60
module load cray-python
module unload cray-libsci_acc

# Clone MPI4PY
git clone https://github.com/mpi4py/mpi4py.git 
cd mpi4py

# Build the mpi4py library
export PE_INSTALL=$INSTALL_DIR
env CC=cc python setup.py build

# Relink with cc instead of gcc
cc -pthread -shared -Wl,-rpath,/opt/python/3.8.5.0/lib -Wl,--no-as-needed build/temp.linux-x86_64-3.8/src/lib-pmpi/mpe.o -o build/lib.linux-x86_64-3.8/mpi4py/lib-pmpi/libmpe.so
cc -pthread -shared -Wl,-rpath,/opt/python/3.8.5.0/lib -Wl,--no-as-needed build/temp.linux-x86_64-3.8/src/lib-pmpi/vt.o -o build/lib.linux-x86_64-3.8/mpi4py/lib-pmpi/libvt.so
cc -pthread -shared -Wl,-rpath,/opt/python/3.8.5.0/lib -Wl,--no-as-needed build/temp.linux-x86_64-3.8/src/lib-pmpi/vt-mpi.o -o build/lib.linux-x86_64-3.8/mpi4py/lib-pmpi/libvt-mpi.so
cc -pthread -shared -Wl,-rpath,/opt/python/3.8.5.0/lib -Wl,--no-as-needed build/temp.linux-x86_64-3.8/src/lib-pmpi/vt-hyb.o -o build/lib.linux-x86_64-3.8/mpi4py/lib-pmpi/libvt-hyb.so
cc -pthread -shared -Wl,-rpath,/opt/python/3.8.5.0/lib build/temp.linux-x86_64-3.8/src/dynload.o -L/opt/python/3.8.5.0/lib -Lbuild/temp.linux-x86_64-3.8 -Wl,--enable-new-dtags,-R/opt/python/3.8.5.0/lib -ldl -o build/lib.linux-x86_64-3.8/mpi4py/dl.cpython-38-x86_64-linux-gnu.so
cc -pthread -shared -Wl,-rpath,/opt/python/3.8.5.0/lib build/temp.linux-x86_64-3.8/src/MPI.o -L/opt/python/3.8.5.0/lib -Lbuild/temp.linux-x86_64-3.8 -Wl,--enable-new-dtags,-R/opt/python/3.8.5.0/lib -ldl -o build/lib.linux-x86_64-3.8/mpi4py/MPI.cpython-38-x86_64-linux-gnu.so

# Install mpi4py
mkdir -p $PE_INSTALL/mpi4py/3.0.3
python setup.py install --prefix=$PE_INSTALL/mpi4py/3.0.3

# Create modulefile
module load craypkg-gen
craypkg-gen -p $PE_INSTALL/mpi4py/3.0.3
craypkg-gen -m $PE_INSTALL/mpi4py/3.0.3

# Update module file to get the right pythonpath
echo "prepend-path PYTHONPATH {$INSTALL_DIR/mpi4py/3.0.3/lib/python3.8/site-packages}" >> $INSTALL_DIR/modulefiles/mpi4py/3.0.3
