import numpy as np

def random_patch_generator(n, imgs, size):
    #n = 100000
    height, width, num_images = imgs.shape

    #sz = 16  # image patch size

    # Get the coordinates of the upper left corner image randomly.
    beginx = np.random.randint(0, width - size, n)
    beginy = np.random.randint(0, height - size, n)

    inputs_list = []

    # Get images randomly
    for i in range(n):
        idx = np.random.randint(0, num_images)
        img = imgs[:, :, idx]
        clop = img[beginy[i]:beginy[i] + size, beginx[i]:beginx[i] + size].flatten()
        inputs_list.append(clop - np.mean(clop))

    return inputs_list

