from .pointnet2_backbone import PointNet2Backbone, PointNet2MSG
from .spconv_backbone import VoxelBackBone8x, VoxelResBackBone8x, VoxelWideResBackBone8x, VoxelWideResBackBone_L8x
from .spconv_backbone_transbn import VoxelBackBone8x_DualBN, VoxelResBackBone8x_DualBN
from .spconv_unet import UNetV2
from .IASSD_backbone import IASSD_Backbone
from .dsvt import DSVT
from .dsvt_sparse import DSVT_Sparse
from .spconv_backbone_voxelnext import VoxelResBackBone8xVoxelNeXt
from .spconv_backbone_voxelnext2d import VoxelResBackBone8xVoxelNeXt2D

__all__ = {
    'VoxelBackBone8x': VoxelBackBone8x,
    'UNetV2': UNetV2,
    'PointNet2Backbone': PointNet2Backbone,
    'PointNet2MSG': PointNet2MSG,
    'VoxelResBackBone8x': VoxelResBackBone8x,
    'VoxelWideResBackBone8x': VoxelWideResBackBone8x,
    'VoxelWideResBackBone_L8x': VoxelWideResBackBone_L8x,
    # Dataset-specific Norm Layer
    'VoxelBackBone8x_DualBN':VoxelBackBone8x_DualBN,
    'VoxelResBackBone8x_DualBN':VoxelResBackBone8x_DualBN,
    'IASSD_Backbone': IASSD_Backbone,
    'DSVT': DSVT,
    'DSVT_Sparse': DSVT_Sparse,
    'VoxelResBackBone8xVoxelNeXt': VoxelResBackBone8xVoxelNeXt,
    'VoxelResBackBone8xVoxelNeXt2D': VoxelResBackBone8xVoxelNeXt2D,
}
