import argparse
from pathlib import Path
from runner import run_settings


parser = argparse.ArgumentParser("real")
parser.add_argument("--setting", required=True)
parser.add_argument("--verbose", type=int, default=2)
parser.add_argument("--base-path", type=str, default="/mnt/media/datasets")

args = parser.parse_args()
verbose = args.verbose
mode = args.setting
base_path = args.base_path

if mode == "eurlex":
    regularization_range = {("cce", True): (-4, 0.1), ("cce", False): (-4, 0.1),
                            ("bce", True): (-7, -4), ("bce", False): (-7, -4)}
    run_settings(Path(base_path) / "Eurlex4k", Path("eurlex.json"),
                 regularization_range=regularization_range,
                 num_epochs=80, learning_rate=1e-3,
                 step_size=0.5, verbose=verbose)
elif mode == "wiki10":
    regularization_range = {("cce", True): (-4, 0.1), ("cce", False): (-4, 0.1),
                            ("bce", True): (-7, -4), ("bce", False): (-7, -4)}
    run_settings(Path(base_path) / "Wiki10", Path("wiki10.json"),
                 regularization_range=regularization_range,
                 num_epochs=80, learning_rate=1e-3,
                 step_size=1.0, batch_size=256, hidden_layer=512, shuffle_buffer=512, verbose=verbose)
else:
    regularization_range = {("cce", False): (-5, -1), ("cce", True): (-6, -2),
                            ("bce", False): (-11, -6), ("bce", True): (-11, -6)}
    run_settings(Path(base_path) / "AmazonCat13K", Path("amazoncat13k.json"), num_epochs=20, learning_rate=5e-4,
                 regularization_range=regularization_range,
                 step_size=1.0, batch_size=256, hidden_layer=512, shuffle_buffer=512, verbose=verbose)

