import os 

import numpy as np
import numpy as np
import matplotlib.pyplot as plt

from typing import List
from collections import Counter
import scipy.stats as stats


def make_json_serializable(obj):
    """Convert NumPy types in an object to standard Python types."""
    if isinstance(obj, np.integer):  # Convert numpy integers to Python int
        return int(obj)
    elif isinstance(obj, np.floating):  # Convert numpy floats to Python float
        return float(obj)
    elif isinstance(obj, np.ndarray):  # Convert numpy arrays to Python lists
        return obj.tolist()
    elif isinstance(obj, list):  # Recursively process lists
        return [make_json_serializable(item) for item in obj]
    elif isinstance(obj, dict):  # Recursively process dictionaries
        return {key: make_json_serializable(value) for key, value in obj.items()}
    else:  # Return the object as-is if no conversion is needed
        return obj

def get_feature_distribution(column: List):
    if isinstance(column[0],float):
        # print('numerical column')
        # return ('numerical_test', False, Counter(column))
        stat, p_value = stats.shapiro(column)
        if p_value > 0.05:
            normal_distr = True
        else:
            normal_distr = False
        return ('numerical', normal_distr, {'min': min(column), 'max': max(column),
                'mean': np.mean(column), 'median': np.median(column),
                'std': np.std(column), 'data':column})
    else:
        # print('categorical column')
        return ('categorical', False, Counter(column))

def plot_generated_data(output_path, original_data, new_data):
    for var in range(new_data.shape[0]):
        plt.figure(figsize=(15,6))
        plt.plot(new_data[var, :, 0:200].T, '--', color='orange', alpha=0.3)
        plt.plot(np.array(original_data[var])[:, 0:200].T, lw=1, alpha=0.8)
        plt.savefig(os.path.join(output_path, f'generated_data_plot.pdf'))
        plt.close()