
from utils.evaluation.distance_based_measures import calculate_ed, calculate_dtw
from utils.evaluation.feature_based_measures import calculate_mdd, calculate_acd, calculate_sd, calculate_kd
from utils.evaluation.shapelet_based_measures import calculate_shapelet_recons_err


# -------------------------------------------------------------------------------------------------------- #
# Global TSG Evaluation

def tsg_evaluation(original_dataset, generated_dataset):
    
    print(original_dataset.shape)

    result = {'MDD': None,
            'ACD': None,
            'SD': None,
            'KD': None,
            'ED': None,
            'DTW':None,
            'SHAP-RE':None}

    # ------------------------------------------------------------------------ #
    # Feature-based measures
    print('\nFeature-based Evaluation')
    
    mdd = calculate_mdd(original_dataset, generated_dataset)
    result['MDD'] = mdd
    
    acd = calculate_acd(original_dataset, generated_dataset)
    result['ACD'] = acd
    
    sd = calculate_sd(original_dataset, generated_dataset)
    result['SD'] = sd
    
    kd = calculate_kd(original_dataset, generated_dataset)
    result['KD'] = kd
    
    # ------------------------------------------------------------------------ #
    # Distance-based measures
    print('\nDistance-based Evaluation')

    ed = calculate_ed(original_dataset,generated_dataset)
    result['ED'] = ed

    dtw = calculate_dtw(original_dataset,generated_dataset)
    result['DTW'] = dtw

    shap_re = calculate_shapelet_recons_err(original_dataset, generated_dataset)
    result['SHAP-RE'] = shap_re

    print(result)

    return(result)