import os
import datetime
import numpy as np
from utils.evaluation.utils_shapelet import USIDL, op_shift, update_A_par, update_S, unsup_obj

def calculate_shapelet_recons_err(orig_data, gen_data, K=20, lambdas =0.1, r=0.25):

    c = 100
    epsilon = 1e-5
    maxIter = 1e3
    maxInnerIter = 5

    # Reverse the transpose operation
    # orig_data = orig_data.transpose(2, 0, 1)
    # gen_data = gen_data.transpose(2, 0, 1)
    orig_data = orig_data
    gen_data = gen_data


    train_data  = orig_data.reshape(orig_data.shape[0], orig_data.shape[1])
    test_data = gen_data.reshape(gen_data.shape[0], gen_data.shape[1])
    train_y  = np.random.rand(orig_data.shape[0])
    test_y = np.random.rand(gen_data.shape[0])
    n_train, p = train_data.shape
    n_test, _ = test_data.shape


    A_rand_init = np.random.randn(n_test, K)
    q = int(np.ceil(p * r))
    runid = f'l_{lambdas}_K_{K}_q_{q}'
    # Train SIDL on original dataset
    S, A, Offsets, F_obj = USIDL(train_data, train_y, lambdas, K, q, c, epsilon, maxIter, maxInnerIter, runid)

    # Learn sparse coding on generated test set with dictionary learned from original dataset
    A_test = A_rand_init
    Offsets_test = np.random.randint(0, p - q, (n_test, K))
    A_test, Offsets_test, F_all_1 = update_A_par(test_data, S, A_test, Offsets_test, lambdas, maxIter, epsilon)

    test_recons_error_sidl = unsup_obj(test_data, S, A_test, Offsets_test, 0) / n_test
    return test_recons_error_sidl



