"""

"""

from sklearn.metrics import mean_squared_error
import numpy as np
import random
import matplotlib.pyplot as plt
import os 
import pandas as pd



def row_exists_in_dataframe(df, columns_to_check, values_to_check):

    # Ensure the DataFrame contains the necessary columns
    missing_columns = [col for col in columns_to_check if col not in df.columns]
    if missing_columns:
        raise ValueError(f"The DataFrame is missing the following columns: {missing_columns}")

    mask = pd.Series([True] * len(df))
    for col, val in zip(columns_to_check, values_to_check):
        if pd.isna(val):
            mask &= df[col].isna()
        else:
            mask &= (df[col] == val)
    # Check if any row matches the criteria
    return mask.any()


def initialize_results_file_tsg(csv_file_path):

    if os.path.exists(csv_file_path):
        df_results = pd.read_csv(csv_file_path)
    else:
        df_results = pd.DataFrame(columns=[
            'key',
            'seed', 'data', 'target', 'augmentation', 
            'n points train', 'n samples train', 'min train windows',
            'train windows', 'windows length', 'overlap', 'period', 
            'sdforge llm', 'learning rate', 'train splitting',
            'permute', 'init value', 'embedding type', 
            'embedding dim', 'generated samples', 'var requested', 
            'var explained', 'MDD', 'ACD', 'SD', 'KD', 'ED', 'DTW', 'SHAP-RE'
        ])
    return df_results


def initialize_results_file_ttm(csv_file_path):

    if os.path.exists(csv_file_path):
        df_results = pd.read_csv(csv_file_path)
    else:
        df_results = pd.DataFrame(columns=[
            'key',
            'seed', 'data', 'target', 'augmentation', 
            'n points train', 'n samples train', 'min train windows',
            'train windows', 'windows length', 'overlap', 'period', 
            'sdforge llm', 'learning rate', 'train splitting',
            'permute', 'init value', 'embedding type', 
            'embedding dim', 'generated samples', 'var requested', 
            'var explained', 'RMSE', 'MASE', 'WQL', 'Sobolev-H1'
        ])
    return df_results


# Function to save results to CSV
def save_results(df_results, csv_file_path, result_row):
    row_count = len(df_results) + 1
    df_results.loc[row_count] = result_row
    df_results.to_csv(csv_file_path, index=False)
