
import os 
import numpy as np
import random
import torch
from transformers import set_seed as hf_set_seed
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

def set_seed(seed):
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    hf_set_seed(seed)
    if torch.cuda.is_available():
        torch.cuda.manual_seed_all(seed)