load('COMPAS_deterministic_convex_workspace_nostationarity_with_cputime.mat');
load('SSG_1_stationarity_measure.mat');
load('SSG_2_stationarity_measure.mat');
load('IPP_SSG_stationarity_measure.mat');
load('IPP_ConEx_stationarity_measure.mat');

% Reference: https://www.mathworks.com/help/matlab/ref/colororder.html
newcolors = [0.83 0.14 0.14
             1.00 0.54 0.00
             % 0.25 0.80 0.54
             0.47 0.25 0.80
             0.00 0.46 0.74];

colororder(newcolors)

fig_obj_vs_iteration = plot(0:step_count_ssg_1, SSG_1_obj_candidate(1:(step_count_ssg_1+1)), 'LineWidth', 1.5);
% Reference: https://www.mathworks.com/help/matlab/ref/gca.html
ax = gca; % current axes
ax.XAxis.Exponent = 4;
hold on
plot(0:step_count_ssg_2, SSG_2_obj_candidate(1:(step_count_ssg_2+1)), 'LineWidth', 1.5);
plot(0:numitersub_ub:(step_count_ippssg), IPP_SSG_obj_candidate(1:(ceil(step_count_ippssg/numitersub_ub))+1), 'LineWidth', 1.5);
plot(0:numitersub_ub:(step_count_ippconex), IPP_ConEx_obj_candidate(1:(ceil(step_count_ippconex/numitersub_ub))+1), 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Iteration t');
% ylabel('\fontsize{12}Objective');
legend({'\fontsize{16}SSG-static', '\fontsize{16}SSG-diminishing', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','northeast');
% title('\fontsize{20}Objective');
saveas(fig_obj_vs_iteration, 'COMPAS_deterministic_convex_objective_result_vs_iteration.eps','epsc');

fig_obj_vs_cputime = plot(SSG_1_time_set, SSG_1_obj_candidate(1:(step_count_ssg_1+1)), 'LineWidth', 1.5);
ax = gca; % current axes
ax.XAxis.Exponent = 1;
hold on
plot(SSG_2_time_set, SSG_2_obj_candidate(1:(step_count_ssg_2+1)), 'LineWidth', 1.5);
plot(IPP_SSG_time_set(1:numitersub_ub:(step_count_ippssg+1)), IPP_SSG_obj_candidate(1:(ceil(step_count_ippssg/numitersub_ub))+1), 'LineWidth', 1.5);
plot(IPP_ConEx_time_set(1:numitersub_ub:(step_count_ippconex+1)), IPP_ConEx_obj_candidate(1:(ceil(step_count_ippconex/numitersub_ub))+1), 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Second (s)');
xlim([0 min([SSG_1_time_set(step_count_ssg_1+1), SSG_2_time_set(step_count_ssg_2+1), IPP_SSG_time_set(step_count_ippssg+1), IPP_ConEx_time_set(step_count_ippconex+1)])]);
% ylabel('\fontsize{12}Objective');
legend({'\fontsize{16}SSG-static', '\fontsize{16}SSG-diminishing', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','northeast');
% title('\fontsize{20}Objective');
saveas(fig_obj_vs_cputime, 'COMPAS_deterministic_convex_objective_result_vs_cputime.eps','epsc');

dash_line_length = max(step_count_ssg_1, step_count_ssg_2);
fig_cons_vs_iteration = plot(0:numitersub_ub/2:step_count_ssg_1, SSG_1_cons_candidate(1:numitersub_ub/2:(step_count_ssg_1+1)), 'LineWidth', 1.5);
ax = gca; % current axes
ax.XAxis.Exponent = 4;
hold on
plot(0:numitersub_ub/2:step_count_ssg_2, SSG_2_cons_candidate(1:numitersub_ub/2:(step_count_ssg_2+1)), 'LineWidth', 1.5);
plot(0:numitersub_ub:(step_count_ippssg), IPP_SSG_cons_candidate(1:(ceil(step_count_ippssg/numitersub_ub))+1), 'LineWidth', 1.5);
plot(0:numitersub_ub:(step_count_ippconex), IPP_ConEx_cons_candidate(1:(ceil(step_count_ippconex/numitersub_ub))+1), 'LineWidth', 1.5);
plot(0:dash_line_length, zeros(1, dash_line_length+1), 'black--', 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Iteration t');
ylim([-1.5e-4 1e-4]);
% ylabel('\fontsize{12}Feasibility');
legend({'\fontsize{16}SSG-static', '\fontsize{16}SSG-diminishing', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','southeast', 'NumColumns', 1);
% title('\fontsize{20}Feasibility');
saveas(fig_cons_vs_iteration, 'COMPAS_deterministic_convex_feasibility_result_vs_iteration.eps','epsc');

dash_line_length = ceil(min([SSG_1_time_set(step_count_ssg_1+1), SSG_2_time_set(step_count_ssg_2+1), ...
                             IPP_SSG_time_set(step_count_ippssg+1), IPP_ConEx_time_set(step_count_ippconex+1)]));
fig_cons_vs_cputime = plot(SSG_1_time_set(1:numitersub_ub/2:(step_count_ssg_1+1)), SSG_1_cons_candidate(1:numitersub_ub/2:(step_count_ssg_1+1)), 'LineWidth', 1.5);
ax = gca; % current axes
ax.XAxis.Exponent = 1;
hold on
plot(SSG_2_time_set(1:numitersub_ub/2:(step_count_ssg_2+1)), SSG_2_cons_candidate(1:numitersub_ub/2:(step_count_ssg_2+1)), 'LineWidth', 1.5);
plot(IPP_SSG_time_set(1:numitersub_ub:(step_count_ippssg+1)), IPP_SSG_cons_candidate(1:(ceil(step_count_ippssg/numitersub_ub))+1), 'LineWidth', 1.5);
plot(IPP_ConEx_time_set(1:numitersub_ub:(step_count_ippconex+1)), IPP_ConEx_cons_candidate(1:(ceil(step_count_ippconex/numitersub_ub))+1), 'LineWidth', 1.5);
plot(0:dash_line_length, zeros(1, dash_line_length+1), 'black--', 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Second (s)');
xlim([0 min([SSG_1_time_set(step_count_ssg_1+1), SSG_2_time_set(step_count_ssg_2+1), IPP_SSG_time_set(step_count_ippssg+1), IPP_ConEx_time_set(step_count_ippconex+1)])]);
ylim([-1.5e-4 1e-4]);
% ylabel('\fontsize{12}Feasibility');
legend({'\fontsize{16}SSG-static', '\fontsize{16}SSG-diminishing', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','southeast', 'NumColumns', 1);
% title('\fontsize{20}Feasibility');
saveas(fig_cons_vs_cputime, 'COMPAS_deterministic_convex_feasibility_result_vs_cputime.eps','epsc');

stationarity_frequency = 100;
fig_sta_vs_iteration = plot(0:stationarity_frequency:((length(SSG_1_stationarity_measure)-1)*stationarity_frequency), ...
                            SSG_1_stationarity_measure, 'LineWidth', 1.5);
ax = gca; % current axes
ax.XAxis.Exponent = 4;
hold on
plot(0:stationarity_frequency:((length(SSG_2_stationarity_measure)-1)*stationarity_frequency), ...
     SSG_2_stationarity_measure, 'LineWidth', 1.5);
plot(0:stationarity_frequency:((length(IPP_SSG_stationarity_measure)-1)*stationarity_frequency), ...
     IPP_SSG_stationarity_measure, 'LineWidth', 1.5);
plot(0:stationarity_frequency:((length(IPP_ConEx_stationarity_measure)-1)*stationarity_frequency), ...
     IPP_ConEx_stationarity_measure, 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Iteration t');
% ylabel('\fontsize{12}Stationarity');
legend({'\fontsize{16}SSG-static', '\fontsize{16}SSG-diminishing', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','northeast');
% title('\fontsize{20}Stationarity');
saveas(fig_sta_vs_iteration, 'COMPAS_deterministic_convex_stationarity_result_vs_iteration.eps','epsc');

fig_sta_vs_cputime = plot(SSG_1_time_set(1:stationarity_frequency:((length(SSG_1_stationarity_measure)-1)*stationarity_frequency+1)), ...
                          SSG_1_stationarity_measure, 'LineWidth', 1.5);
ax = gca; % current axes
ax.XAxis.Exponent = 1;
hold on
plot(SSG_2_time_set(1:stationarity_frequency:((length(SSG_2_stationarity_measure)-1)*stationarity_frequency+1)), ...
     SSG_2_stationarity_measure, 'LineWidth', 1.5);
plot(IPP_SSG_time_set(1:stationarity_frequency:((length(IPP_SSG_stationarity_measure)-1)*stationarity_frequency+1)), ...
     IPP_SSG_stationarity_measure, 'LineWidth', 1.5);
plot(IPP_ConEx_time_set(1:stationarity_frequency:((length(IPP_ConEx_stationarity_measure)-1)*stationarity_frequency+1)), ...
     IPP_ConEx_stationarity_measure, 'LineWidth', 1.5);
hold off
xlabel('\fontsize{20}Second (s)');
xlim([0 min([SSG_1_time_set(step_count_ssg_1+1), SSG_2_time_set(step_count_ssg_2+1), IPP_SSG_time_set(step_count_ippssg+1), IPP_ConEx_time_set(step_count_ippconex+1)])]);
% ylabel('\fontsize{12}Stationarity');
legend({'\fontsize{16}SSG-static', '\fontsize{16}SSG-diminishing', '\fontsize{16}IPP-SSG', '\fontsize{16}IPP-ConEx'}, ...
       'Location','northeast');
% title('\fontsize{20}Stationarity');
saveas(fig_sta_vs_cputime, 'COMPAS_deterministic_convex_stationarity_result_vs_cputime.eps','epsc');