Fair Interventions in an Overparameterized World
===

## Overview
This project explores the effects of overparameterization in last layer retraining settings. Specifically we formulate optimally fair weights which scale with the overparameterization ratio. This repository contains code to train base models on imbalanced datasets and to finetune them with varying weights. 

## Usage
### Configs
One can define an experiment as a YAML file in the [configs folder](configs/). The YAML file contains information such as base model training (if desired), finetuning parameters, and dataset information. This is passed to the `run_experiment.py` script with the `--config` flag.

### Running an Experiment
Once the config file is created, it can simply be passed to the `run_experiment.py` script as a commandline argument (see `run_experiment.py --help` for help).