import csv
import os

def log_to_csv(path, row, headers=None):
    os.makedirs(os.path.dirname(path), exist_ok=True)
    write_headers = not os.path.exists(path)
    with open(path, 'a', newline='') as f:
        writer = csv.DictWriter(f, fieldnames=headers or row.keys())
        if write_headers:
            writer.writeheader()
        writer.writerow(row)
