import os
import glob
import pandas as pd
import argparse
import ast

def merge_csv_files(expname):
    """Merge all CSV files in the output directory into a single CSV file."""
    output_dir = f"output_{expname}"
    output_file = f"input_{expname}_prompts.csv"
    
    print(f"Merging CSV files in {output_dir}...")
    
    # Get all CSV files in the output directory
    csv_files = glob.glob(f"{output_dir}/*.csv")
    
    if not csv_files:
        print(f"No CSV files found in {output_dir}.")
        return
    
    # Read and concatenate all CSV files
    all_dfs = []
    for file in csv_files:
        try:
            df = pd.read_csv(file)
            all_dfs.append(df)
            print(f"Added {file} to merge list.")
        except Exception as e:
            print(f"Error reading {file}: {e}")
    
    if not all_dfs:
        print("No valid CSV files to merge.")
        return
    
    # Concatenate all dataframes
    merged_df = pd.concat(all_dfs, ignore_index=True)
    
    # Remove duplicate rows based on filename or other unique identifier
    if 'filename' in merged_df.columns:
        merged_df = merged_df.drop_duplicates(subset=['filename'])
        print(f"Removed duplicate entries. Final count: {len(merged_df)} rows")
    
    # Save the merged dataframe
    merged_df.to_csv(output_file, index=False)
    print(f"Successfully merged {len(csv_files)} CSV files into {output_file}")


def main():
    parser = argparse.ArgumentParser(description='Inference with Llama Vision model on Flickr30k dataset')
    parser.add_argument('--expname', type=str, required=True, help='name of the experiment, will be used to save outputs')
    merge_csv_files(args.expname)

if __name__ == "__main__":
    main()