# HyperDet: Generalizable Detection of Synthesized Images by Generating and Merging A Mixture of Hyper LoRAs

We adhere to the  [univFD](https://github.com/WisconsinAIVision/UniversalFakeDetect) evaluation standards, utilizing accuracy (acc) and average precision (AP) as the metrics.

<p align="center">
<img src="resources/pipline-v1.drawio_00.png" width="100%">></a> <br>
</p>


## Contents

- [Setup](#setup)
- [Data](#data)
- [Evaluation](#evaluation)
- [Training](#training)


## Setup 

### Install packages

```bash
conda create -n your_env_name python=3.9
pip install -r requirements.txt
```

### Download model weights

- download checkpoints from [here](https://drive.google.com/file/d/1Exy4v1m9il_MRKL480bcOAfnu0YTdfWe/view?usp=sharing). We will open after the blind review.

## Data

### Training Data

- Our main model is trained on the same dataset used by the authors of [this work](https://arxiv.org/abs/1912.11035). Download the official training dataset provided [here](https://drive.google.com/file/d/1iVNBV0glknyTYGA9bCxT_d0CVTOgGcKh/view) (dataset size ~ 72GB). 

- Download and unzip the dataset in `datasets/train` directory. The overall structure should look like the following:
```
datasets
└── train			
      └── progan			
           ├── airplane
           │── bird
           │── boat
           │      .
           │      .
```


### Testing Data

- The testing data for the first 11 models in the UnivFD dataset is sourced from [here](https://drive.google.com/file/d/1z_fD3UKgWQyOTZIBbYSaQ-hz4AzUrLC1/view) (dataset size ~19GB), while the testing data for the subsequent 8 models is sourced from [here](https://drive.google.com/file/d/1FXlGIRh_Ud3cScMgSVDbEWmPDmjcrm1t/view?usp=drive_link).
- This should create a directory structure as follows:

```

datasets
└── test					
      ├── progan	
      │── cyclegan   	
      │── biggan
      │      .
      │      .
	  
```
Additionally, the Fake2M dataset can be downloaded [here](https://huggingface.co/datasets/InfImagine/FakeImageDataset).

## Evaluation

- You can evaluate the model on one generative model by specifying the paths of real and fake datasets
```bash
python HyperDet_test.py  --arch=CLIP:ViT-L/14   --ckpt=pretrained_weights/HyperDet.pth   --result_folder=clip_vitl14  --real_path datasets/test/progan/0_real --fake_path datasets/test/progan/1_fake
```

Note that if no arguments are provided for `real_path` and `fake_path`, the script will perform the evaluation on all the domains specified in `dataset_paths.py`.

- The results will be stored in `results/<folder_name>` in two files: `ap.txt` stores the Average Prevision for each of the test domains, and `acc.txt` stores the accuracy (with 0.5 as the threshold) for the same domains.

## Training

- The model can then be trained with the following command:
```bash
python train.py --name=clip_vitl14 --wang2020_data_path=datasets/ --data_mode=wang2020  --arch=CLIP:ViT-L/14  --fix_backbone
```
- **Important**: do not forget to use the `--fix_backbone` argument during training, which makes sure that the only the linear layer's parameters will be trained.
