# BEYOND: BE Your Own NeighborhooD

Deep Neural Networks (DNNs) have achieved excellent per- formance in various fields. However, DNNs’ vulnerability to Adversarial Examples (AE) hinders their deployments to safety-critical applications. This paper presents a novel AE detection framework, named BEYOND, for trustworthy pre- dictions. BEYOND performs the detection by distinguishing the AE’s abnormal relation with its augmented versions, i.e. neighbors, from two prospects: representation similarity and label consistency. An off-the-shelf Self-Supervised Learning (SSL) model is used to extract the representation and predict the label for its highly informative representation capacity compared to supervised learning models. For clean samples, their representations and predictions are closely consistent with their neighbors, whereas those of AEs differ greatly. Fur- thermore, we explain this observation and show that by lever- aging this discrepancy BEYOND can effectively detect AEs. We develop a rigorous justification for the effectiveness of BEYOND. Furthermore, as a plug-and-play model, BEYOND can easily cooperate with the Adversarial Trained Classifier (ATC), achieving the state-of-the-art (SOTA) robustness ac- curacy. Experimental results show that BEYOND outperforms baselines by a large margin, especially under adaptive attacks. Empowered by the robust relation net built on SSL, we found that BEYOND outperforms baselines in terms of both detection ability and speed.

# Run the code

## 1. Download Pretrained SSL Model

* Cifar10 & CIfar100: [Solo-learn](https://github.com/vturrisi/solo-learn)
* ImageNet: [SimSiam](https://github.com/facebookresearch/simsiam)

## 2. Train Clasifier

```
python train_resnet18.py
```

## 3. CleanSelect

````
cd AEs
python CleanSelect.py
````

## 4. Generate AEs

```
# FGSM, PGD, CW
python attacks.py
# AutoAttack
python auto_attack.py
```

## 5. Detect

```
python detect_cifar10.py
```

## 6. Adaptive Attack

```
python adaptive_attack.py
python run_orthogonal_pgd.py
```









