# RoBERT codebase

This is codebase for training/evaluating a RoBERT model as described in our paper.

## Installation

```shell
python3.8 -m venv ./venv # setup venv environment
source /venv/bin/activate
pip install -r requirements.txt
```

in case you want to re-use our scripts codes, you also need to install [`nodejs`](https://nodejs.org/en) runtime (make sure you're familiar with `JavaScript`/`TypeScript`).

then follow standard `npm` installation and `tsc` compliation.

```shell
npm i
npm run build
```

you could also find hyperparameter we used in the `scripts` codebase, read codes in it would give you some sense about how we train/eval models to obtain resuls in paper.

## Training

```shell
source /venv/bin/activate
export PYTHONPATH=$PYTHONPATH:`pwd`/robert

python robert/agent/main.py --task {pointmaze|ur5e|shadow} --eval-raio 4  --seed {1111|2222|3333}
```


## Evaluation

```shell
source /venv/bin/activate
export PYTHONPATH=$PYTHONPATH:`pwd`/robert

python robert/agent/eval.py --task {pointmaze|ur5e|shadow} --eval-ratio 4 --seed 1111 --eval-name {...various eval-names for task fulfillments as in our paper, their names could be found in commands_{pointmaze|ur5e|shadow}.py...}
```

