import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--seed", type=int, default=1111)
parser.add_argument("--name", type=str, default="default")
parser.add_argument("--eval-name", type=str, default="")
parser.add_argument("--device-1", type=int, default=0)
parser.add_argument("--device-2", type=int, default=0)
parser.add_argument("--device-3", type=int, default=0)
parser.add_argument("--eval-ratio", type=int, default=1)
parser.add_argument("--crop-ratio", type=float, default=0)

parser.add_argument("--fake-eval", type=bool, default=False)
parser.add_argument("--no-mask", type=float, default=0)
parser.add_argument(
    "--model-kind", type=str, default="transformer", choices=["transformer", "mlp"]
)

parser.add_argument(
    "--task", type=str, default="ur5e", choices=["pointmaze", "shadow", "ur5e"]
)
parser.add_argument(
    "--eval-policy", type=str, default="random", choices=["random", "zero", "model"]
)
# parser.add_argument("--action_kind", type=str, default="all")

parser.add_argument("--hidden-size", type=int, default=768)
parser.add_argument("--n", type=int, default=6)
parser.add_argument("--pre-steps", type=int, default=30)
parser.add_argument("--post-steps", type=int, default=20)
parser.add_argument("--num-centers", type=int, default=10)
parser.add_argument("--batch-size", type=int, default=512)
parser.add_argument("--shrink", type=int, default=1)
parser.add_argument("--lr-ratio", type=float, default=1.0)
parser.add_argument("--mask-begin", type=float, default=0.02)
parser.add_argument("--mask-end", type=float, default=0.62)




args = parser.parse_args()


task = args.task

DEVICE1 = f"cuda:{args.device_1}"
DEVICE2 = f"cuda:{args.device_2}"
DEVICE3 = f"cuda:{args.device_3}"
