import cv2
import numpy as np
from pathlib import Path


task = "ur5e"
eval_name = "front_back"
is_ref = False
camera_id = 1
# IMAGE_CLIP_INDEX = [1, 31, 75, 79, 97, 106, 141, 148, 184, 216, 222]
# swing index: [0, 23, 104, 120, 195, 221, 302, 354, 396]
vidcap = cv2.VideoCapture(
    f"./eval_video/{task}/{eval_name}/eval_video/{eval_name}{'' if camera_id == 0 else f'{camera_id}'}{'' if not is_ref else '_fake_eval'}.mp4"
)
success, image = vidcap.read()
assert success
count = 0

images = []
while success:
    # cv2.imwrite("frame%d.jpg" % count, image)  # save frame as JPEG file
    success, image = vidcap.read()
    images.append(image)
    # print("Read a new frame: ", success)
    count += 1


dir_path = f"./imgs/{task}/{eval_name}"
Path(dir_path).mkdir(parents=True, exist_ok=True)
for i in range(0, len(images) - 1):
    cv2.imwrite(f"{dir_path}/clip_{i}{'_ref' if is_ref else ''}.jpg", images[i])
