import cv2
import numpy as np
from pathlib import Path
import os


task = "pointmaze"
eval_name = "stay"
is_ref = False
our_video = cv2.VideoCapture(
    f"./eval_video/{task}/{eval_name}/eval_video/{eval_name}.mp4"
)
ref_video = cv2.VideoCapture(
    f"./eval_video/{task}/{eval_name}/eval_video/{eval_name}_fake_eval.mp4"
)

our_videos = []
ref_videos = []
for v, vs in [(our_video, our_videos), (ref_video, ref_videos)]:
    success, image = v.read()
    assert success
    count = 0
    vs.append(image)

    while success:
        # cv2.imwrite("frame%d.jpg" % count, image)  # save frame as JPEG file
        success, image = v.read()
        if success:
            vs.append(image)
        # print("Read a new frame: ", success)
        count += 1


assert len(our_videos) == len(ref_videos) > 0
del our_video, ref_video

tracking_loss_path = f"./eval_video/{task}/{eval_name}/tracking_imgs"
track_imgs = [
    cv2.resize(cv2.imread(f"{tracking_loss_path}/img_{i+1}.png"), (640, 640))
    for i in range(len(os.listdir(tracking_loss_path)))
]

assert len(track_imgs) == len(our_videos)


LENGTH = len(track_imgs)

CANVAS_SIZE = (720, 640 * 3)
FIRST = slice(0, 640)
SECOND = slice(640, 640 * 2)
THIRD = slice(640 * 2, 640 * 3)


canvas = [np.zeros(CANVAS_SIZE + (3,), dtype=np.uint8) for _ in range(LENGTH)]


out = cv2.VideoWriter("./test.mp4", cv2.VideoWriter_fourcc(*"mp4v"), 20, (1920, 720))

for i in range(LENGTH):
    canvas[i][80:, FIRST] = ref_videos[i]
    canvas[i][80:, SECOND] = our_videos[i]
    canvas[i][80:, THIRD] = track_imgs[i]

    out.write(canvas[i])


cv2.destroyAllWindows()

out.release()
