const SEED = [1111, 2222, 3333];
import pAll from "p-all";
import runSingleTrain, { TrainArgs } from "./train.mjs";
import _ from "lodash";

const GPUS = parseInt(process.argv[2]);
const ENV = process.argv[3];

const args = [
  {},
  {
    noMask: 1,
  },
  {
    noMask: 0.15,
  },
  {
    noMask: 0.7,
  },
  {
    noMask: 0.5,
  },
  {
    noMask: 0.35,
  },
];

async function runAll() {
  let allCmds = args.reduce<Partial<TrainArgs>[]>((acc, { noMask }) => {
    let to_be_added: Partial<TrainArgs>[] = [];
    for (let j = 0; j < 3; j++) {
      to_be_added.push({
        ...(noMask ? { noMask } : {}),
        seed: SEED[j],
        skip: false,
        evalRatio: 4,
      });
    }
    return [...acc, ...to_be_added];
  }, []);

  allCmds = _.shuffle(allCmds);

  console.log(
    `${ENV} in total, ${allCmds.length} commands are: ${JSON.stringify(
      allCmds
    )}`
  );
  await pAll(
    allCmds.map((arg) => () => runSingleTrain("mask", arg)),
    { concurrency: GPUS }
  );
}

await runAll();
