import { execa, $ } from "execa";
const GPUS = parseInt(process.argv[2]);
import _ from "lodash";
const ENV = process.argv[3];

export interface TrainArgs {
  n: number;
  batchSize: number;
  lrRatio: number;
  hiddenSize: number;
  shrink: number;
  seed: number;
  skip: boolean;
  evalRatio: number;
  cropRatio: number;
  noMask: number;
  modelKind: "mlp" | "transformer";
  numCenters: number;
}

let totalRuns = 0;
let gpuNos = Array.from(_.range(0, GPUS));

const camelToSnakeCase: (s: string) => string = (s) =>
  s.replace(/[A-Z]/g, (letter) => `-${letter.toLowerCase()}`);

export default async function runSingleTrain(
  expName: string,
  allArgs: Partial<TrainArgs>
) {
  const { skip = false, ...args } = allArgs;
  const name = `${expName}_${totalRuns}_shrink_${args.shrink ?? 1}_modality_${args.numCenters ?? 10}_mask_${args.noMask ?? 0}_crop_${args.cropRatio ?? 0}`;
  totalRuns += 1;
  const _args = Array.from(
    Object.entries(args).map(([k, v]) => `--${camelToSnakeCase(k)} ${v}`)
  );
  console.log(`start to run ${totalRuns} experiment, skip is: ${skip} `);
  if (!gpuNos.length) {
    throw new Error(`no gpu available: ${JSON.stringify(gpuNos)}`);
  }
  const gpuNo = gpuNos.pop()!;

  const cmd = skip
    ? 'echo "skip"'
    : `python3 robert/agent/main.py ${_args.join(
        " "
      )} --device-1 ${gpuNo} --device-2 ${gpuNo} --device-3 ${gpuNo} --task ${ENV} --name ${name}`;
  console.log(`command to be ran is: ${cmd}`);
  const subProcess = $({
    shell: "/bin/bash",
    all: true,
  })`${cmd}`;
  subProcess.pipeAll!(`./train_${ENV}_${expName}_${totalRuns}.log`);
  await subProcess;
  gpuNos.push(gpuNo);
  await sleep(5);
}

async function sleep(second: number): Promise<void> {
  await new Promise<void>((resolve, reject) =>
    setTimeout(() => resolve(), second * 1000)
  );
}
