import glob
import seaborn as sns
import colorcet as cc
import pandas as pd
import os
from os import path
from tqdm import tqdm
import matplotlib.lines as mlines

from args import args
from matplotlib import pyplot as plt
from scipy.optimize import curve_fit
import sys
import numpy as np
from matplotlib.ticker import FormatStrFormatter

import torch
import random
import matplotlib as mpl
from pathlib import Path
import matplotlib.patches as mpatches


mpl.rcParams["figure.dpi"] = 200
seed = 0
np.random.seed(seed)
torch.manual_seed(seed)
torch.cuda.manual_seed_all(seed)
random.seed(seed)
sns.set_theme()


RANDOM_SCORE = 0.38


all_rlts = []

task = args.task
eval_name = args.eval_name

path_dir = f"./eval_video/{task}/{eval_name}"

achieved_pos = torch.load(os.path.join(path_dir, "./aps.pt"))
command_pos = torch.load(os.path.join(path_dir, "./cps.pt"))
ds1 = pd.DataFrame(
    {
        "x": [0] + achieved_pos[:, 0, 0].tolist() + command_pos[:, 0].tolist(),
        "y": [0] + achieved_pos[:, 0, 1].tolist() + command_pos[:, 1].tolist(),
        "kind": ["achieved"]
        + ["achieved"] * achieved_pos.size(0)
        + ["command"] * command_pos.size(0),
    }
)


plt.figure(figsize=(4.8, 4.8))
fig = sns.scatterplot(data=ds1, x="x", y="y", style="kind", hue="kind")
# plt.ylim((-6e-3, 6e-3))
# plt.xlim((-6e-3, 6e-3))
plt.show()
Path(f"./imgs/task/{task}").mkdir(exist_ok=True, parents=True)
fig.get_figure().savefig(
    f"./imgs/task/{task}/{eval_name}.png", bbox_inches="tight", pad_inches=0.05
)

plt.close()
