import os

os.environ["MKL_SERVICE_FORCE_INTEL"] = "1"
# os.environ['MUJOCO_GL'] = 'egl'

from pathlib import Path
import numpy as np
import torch
from dm_env import specs
from dm_control import viewer
from envs import dmc
from envs.video import VideoRecorder
from pathlib import Path

# POINTMASS = "shadowhand_dummy"
POINTMASS = "ur5e_dummy"
# POINTMASS = "point_mass_maze_reach_bottom_left"


def view(record=False):
    env = dmc.make(POINTMASS, seed=0, static_start=50 )

    action_spec = env.action_spec()
    obs_spec = env.observation_spec()
    if record:
        video_recorder = VideoRecorder(
            Path("./"), camera_id=0, use_wandb=False, render_size=480
        )
        video_recorder.init(env, True)

    time_step = env.reset()

    cnt = 0

    def random_policy(time_step):
        nonlocal action_spec, env, cnt, record, video_recorder
        if cnt > 0 and record:
            video_recorder.record(env)
        action = np.random.uniform(-1, 1, size=action_spec.shape)

        # action = np.ones(action_spec.shape) * -1
        # action = np.zeros(action_spec.shape)
        # action = np.array([.05,.05])
        obs = time_step.observation[:5]
        # action[-1] = 1.0
        # action[3:] = 0.0
        # print(f'action: {action[-2:]}')

        # action = np.zeros(action_spec.shape)

        # print(np.round(obs, decimals=4))
        cnt += 1
        if cnt == 200:
            video_recorder.save("./env.mp4")
        return action

    viewer.launch(env, width=1080, height=1080, policy=random_policy)


def inspect():
    env = dmc.make(POINTMASS, seed=0)

    action_spec = env.action_spec()
    obs_spec = env.observation_spec()

    time_step = env.reset()

    cnt = 0
    while not time_step.last():
        action = np.random.uniform(
            action_spec.minimum, action_spec.maximum, size=action_spec.shape
        )
        time_step = env.step(action)
        cnt += 1


if __name__ == "__main__":
    view(True)
