#!/bin/bash

set -e 

gen_video() {
    env=$1
    task=$2
    camera_id=$3
    if [ "$camera_id" -eq "0" ]; then
        camera_id=""
    fi

    dir=eval_video/$env/$task/tracking_imgs
    ovideodir=eval_video/$env/$task/eval_video
    python robert/agent/draw_tracking_loss.py --task $env --eval-name $task &&
    ffmpeg -y -framerate 20 -i $dir/img_%d.png -c:v libx264 $dir/"$task"_mae.mp4 &&
    ffmpeg -y -i $dir/"$task"_mae.mp4 -s 640x640 -c:a copy $dir/"$task"_mae_resized.mp4 &&

    rm -rf videos/$env/$task
    mkdir -p videos/$env/$task

    outdir=videos/$env/$task
    ffmpeg -y -i $ovideodir/"$task""$camera_id"_fake_eval.mp4 -i $ovideodir/"$task""$camera_id".mp4 -i $dir/"$task"_mae_resized.mp4 -filter_complex hstack=inputs=3 $outdir/output.mp4  &&
    ffmpeg -i $outdir/output.mp4 -filter:v "pad=1920:720:0:80,setsar=1" -c:a copy $outdir/output2.mp4 -y &&
    ffmpeg -i $outdir/output2.mp4 -vf "drawtext=text='Reference':fontcolor=white:fontsize=32:box=1:boxcolor=black@0.5:boxborderw=5:x=240:y=25,drawtext=text='Achieved':fontcolor=white:fontsize=32:box=1:boxcolor=black@0.5:boxborderw=5:x=880:y=25,drawtext=text='Tracking Loss':fontcolor=white:fontsize=32:box=1:boxcolor=black@0.5:boxborderw=5:x=1520:y=25" -codec:a copy $outdir/"$env"_"$task".mp4 -y
}


env=pointmaze
for task in stay circle triangles heart;
do
    gen_video $env $task 0
done

# env=ur5e
# for task in reacher hang 
# do
#     gen_video $env $task 0
# done
# for task in front_back swing_0.52 
# do 
#     gen_video $env $task 1
# done

# env=shadow

# for task in six thumb dynamic_fire_1st rsp  rsp-full-mask dynamic_fire_1st-full-mask
# do
#     gen_video $env $task 1
# done