#!/bin/bash
export PYTHONPATH=$PYTHONPATH:`pwd`/robert

i=0
GPUS=$1
for numcenters in 10
do
    for n in 2 4 8
    do

        for seed in 1111 2222 3333
        do
            CUDA_VISIBLE_DEVICES=$i python3 robert/agent/main.py --task pointmaze --num-centers $numcenters --device-2 0 --name "${numcenters}_${n}_${seed}" --n $n --seed $seed &> "${numcenters}_${n}_${seed}.log"  &
            sleep 90
            ((i=$i+1))
            ((i=$i%$GPUS))
        done
    done
    # wait    

done
wait

