Benchmarking ML for MD simulation

# install dependencies and `mdsim` as a package

```
pip install -r requirements.txt
pip install -e ./
```

# install plummed 
```
sudo apt-get install libatlas-base-dev
conda install -c conda-forge py-plumed plumed
```

Plumed also need `ase` nightly:

```
pip install --upgrade git+https://gitlab.com/ase/ase.git@master
```

# Training and simulation

Preprocessing data using the scripts in the folder `/preprocessing`. `md17.py` also handles data downloading. We unify all units to eV for energy and eV/A for forces.

Training with `main.py` and simulate with `simulate.py`. For example, train SchNet on water-1k with the command:


```
python main.py --mode train --config-yml configs/water/schnet.yml --size 1k 
```

and simulate with:

```
python simulate.py --config_yml configs/simulate/water.yml --model_dir MODELPATH
```