# Implicit Search via Discrete Diffusion: A Study on Chess


This repository contains code for training and evaluating the models in the paper "Implicit Search via Discrete Diffusion: A Study on Chess".

## Setup
All required packages can be found in requirements.txt. You can install them in a new environment with
```
conda create -n diffusearch python=3.9
conda activate diffusearch

pip install -r requirements.txt -f https://download.pytorch.org/whl/torch_stable.html
```

## Usage
Training and evaluation commands are provided under the `scripts` directory. 
```
# train and eval Transformer S-A
bash scripts/train-s_a.sh

# train and eval Transformer S-V
bash scripts/train-s_v.sh

# eval Transformer + MCTS given the trained S-A and S-V model
python run_mcts.py

# train and eval Transformer SA-V
bash scripts/train-sa_v.sh

# train and eval DiffuSearch
bash scripts/train-ddm-s_asa.sh

# test a given case on DiffuSearch
python src/test_infer_ddm.py

# test a given case on Transformer
python src/test_infer.py
```