# Initialize logging
import logging
from datetime import datetime
import yaml
import argparse

def init_logging(save_dir, config=None):
    if config:
        current_time = datetime.now().strftime("%Y-%m-%d_%H-%M-%S")
        print(f"PF_Logging to {save_dir}log_{current_time}.log")
        filename = f"{save_dir}PF_log_{current_time}.log"
        logging.basicConfig(filename=filename, level=logging.INFO, 
                            format='%(asctime)s - %(levelname)s - %(message)s', 
                            datefmt='%Y-%m-%d %H:%M:%S')
        # Log the configuration values
        logging.info("Configuration values:")
        for section, settings in config.items():
            logging.info(f"Section: {section}")
            for key, value in settings.items():
                logging.info(f"{key}: {value}")
    
    else:
        print("No configuration values found.")
        logging.basicConfig(level=logging.INFO, 
                            format='%(asctime)s - %(levelname)s - %(message)s', 
                            datefmt='%Y-%m-%d %H:%M:%S')
            
# Load configuration settings
def load_config(file_path):
    with open(file_path, 'r') as file:
        return yaml.safe_load(file)

def parse_arguments():
    parser = argparse.ArgumentParser(description='Process the path to the config file.')
    parser.add_argument('--config', type=str, required=True, help='Path to the config file.')
    return parser.parse_args()