
import numpy as np
class Microscope:
    """
    Simulates the microscope acqusition of an image and spectra
    
    
    """
    
    def __init__(self, path) -> None:
        self.load_data(path)
        self.load_survey_image()
        self.load_SI()
        self.load_others()
        pass
        
    
    def load_data(self, path: str) -> None:# scifi nsid reader---
        """
        Load the data from the specified path
        """
        self.data = np.load(path, allow_pickle=True).tolist()
        
        pass
    # def move_beam(self, x: int, y: int) -> None:
    #     """
    #     Move the beam to the specified x, y coordinates
    #     """
    #     pass
    
    def get_spectrum(self, x, y) -> np.ndarray:
        """
        Get the spectrum at the current beam position
        """
        spectrum = self.spec_img[y, x]
        return spectrum

    
    def load_survey_image(self, key=3) -> np.ndarray:
        """
        Load the survey image
        """
        try:
            if key is None:
                self.survey_img = self.data['image']
            else:
                self.survey_img = self.data[key]['image']
        except KeyError:
            self.survey_img = self.data['image']

    def load_SI(self, key=3) -> np.ndarray:
        """
        Load the spectrum image
        """
        try:
            if key is None:
                self.spec_img = self.data['spectrum image']
            else:
                self.spec_img = self.data[key]['spectrum image']
        except KeyError:
            self.spec_img = self.data['spectrum image']

    def load_others(self, key=3) -> np.ndarray:
        """
        Load the other data
        """
        try:
            if key is None:
                self.energy_axis = self.data['energy axis']
                self.scale = self.data['scale']
            else:
                self.energy_axis = self.data[key]['energy axis']
                self.scale = self.data[key]['scale']
        except KeyError:
                self.energy_axis = self.data['energy axis']
                self.scale = self.data['scale']
        
# class Microscope_AS(Microscope):
#     """Autoscript """
    
#     def __init__(self, path) -> None:
#         super().__init__(path)
#         pass
    
#     def get_HAADF
        
if __name__ == '__main__':
    path = 'in_data_sl/Plasmonic_EELS_FITO0_edgehole_01.npy'
    mic = Microscope(path)
    print(mic.survey_img.shape)
    print(mic.spec_img.shape)
    print(mic.energy_axis.shape)
    print(mic.scale)
    print(mic.get_spectrum(10, 10))
    print(mic.get_spectrum(100, 100))