import numpy as np
from scipy.signal import find_peaks


def scalarizer_peak_hard_coded(targets, features, indices):
    """
    Scalarizer for the targets
    targets: np.ndarray
    """
    peaks_all, features_all, indices_all = [], [], []
    for i, t in enumerate(targets):
        peak = find_peaks(t, width=5)[1]["prominences"]# take the spectrum and find the peaks
        if len(peak) == 0:
            continue
        peaks_all.append(np.array([peak[0]]) if len(peak) > 1 else peak)
        features_all.append(features[i])
        indices_all.append(indices[i])
    peaks_all = np.concatenate(peaks_all)
    features_all = np.array(features_all)
    indices_all = np.array(indices_all)
    
    
    return peaks_all, features_all, indices_all

def scalarizer_sum(targets, features, indices):
    """
    Scalarizer for the targets
    targets: np.ndarray
    """
    peaks_all, features_all, indices_all = [], [], []
    for i, t in enumerate(targets):
        peak = t.sum()
        peaks_all.append(peak)
        features_all.append(features[i])
        indices_all.append(indices[i])
    peaks_all = np.array(peaks_all)## notice concatenate doesnt work here
    features_all = np.array(features_all)
    indices_all = np.array(indices_all)
    return peaks_all, features_all, indices_all

def scalarizer_mean(targets, features, indices):
    """
    Scalarizer for the targets
    targets: np.ndarray
    """
    peaks_all, features_all, indices_all = [], [], []
    for i, t in enumerate(targets):
        peak = t.mean()
        peaks_all.append(peak)
        features_all.append(features[i])
        indices_all.append(indices[i])
    peaks_all = np.array(peaks_all)## notice concatenate doesnt work here
    features_all = np.array(features_all)
    indices_all = np.array(indices_all)
    return peaks_all, features_all, indices_all

def scalarizer_inv_mean(targets, features, indices):
    """
    Scalarizer for the targets
    targets: np.ndarray
    """
    peaks_all, features_all, indices_all = [], [], []
    for i, t in enumerate(targets):
        peak = 1/t.mean()
        peaks_all.append(peak)
        features_all.append(features[i])
        indices_all.append(indices[i])
    peaks_all = np.array(peaks_all)## notice concatenate doesnt work here
    features_all = np.array(features_all)
    indices_all = np.array(indices_all)
    return peaks_all, features_all, indices_all


def scalarizer_max(targets, features, indices):
    """
    Scalarizer for the targets
    targets: np.ndarray
    """
    peaks_all, features_all, indices_all = [], [], []
    for i, t in enumerate(targets):
        peak = t.max()
        peaks_all.append(peak)
        features_all.append(features[i])
        indices_all.append(indices[i])
    peaks_all = np.array(peaks_all)## notice concatenate doesnt work here
    features_all = np.array(features_all)
    indices_all = np.array(indices_all)
    return peaks_all, features_all, indices_all

# def scalarizer_sum_between(targets, features, indices):
#     """
#     Scalarizer for the targets
#     targets: np.ndarray
#     """
#     peaks_all, features_all, indices_all = [], [], []
#     for i, t in enumerate(targets):
#         peak = t.max()
#         peaks_all.append(peak)
#         features_all.append(features[i])
#         indices_all.append(indices[i])
#     peaks_all = np.array(peaks_all)## notice concatenate doesnt work here
#     features_all = np.array(features_all)
#     indices_all = np.array(indices_all)
#     return peaks_all, features_all, indices_all

# def scalarizer_peak_hard_coded_reciprocal(targets, features, indices):
#     """
#     Scalarizer for the targets
#     targets: np.ndarray
#     """
#     peaks_all, features_all, indices_all = [], [], []
#     for i, t in enumerate(targets):
#         peak = find_peaks(t, width=5)[1]["prominences"]# take the spectrum and find the peaks
#         if len(peak) == 0:
#             continue
#         peaks_all.append(np.array([peak[0]]) if len(peak) > 1 else peak)
#         features_all.append(features[i])
#         indices_all.append(indices[i])
#     peaks_all = np.concatenate(peaks_all)
#     features_all = np.array(features_all)
#     indices_all = np.array(indices_all)
    
    
#     return 1/peaks_all, features_all, indices_all

# def scalarizer_weighted_peak(targets, features, indices, target_position=500, weight_factor=0.1):
#     peaks_all, features_all, indices_all = [], [], []
#     for i, t in enumerate(targets):
#         peaks = find_peaks(t, width=5)[1]["prominences"]
#         peak_positions = find_peaks(t, width=5)[0]  # peak positions
#         if len(peaks) == 0:
#             continue
#         weights = np.exp(-weight_factor * np.abs(peak_positions - target_position))
#         weighted_peaks = peaks * weights
#         peaks_all.append(np.array([weighted_peaks[0]]) if len(weighted_peaks) > 1 else weighted_peaks)
#         features_all.append(features[i])
#         indices_all.append(indices[i])
#     peaks_all = np.concatenate(peaks_all)
#     features_all = np.array(features_all)
#     indices_all = np.array(indices_all)
    
#     return peaks_all, features_all, indices_all


# def scalarizer_normalized_peak(targets, features, indices):
#     peaks_all, features_all, indices_all = [], [], []
#     for i, t in enumerate(targets):
#         peaks = find_peaks(t, width=5)[1]["prominences"]
#         if len(peaks) == 0:
#             continue
#         max_peak = np.max(peaks)
#         normalized_peaks = peaks / max_peak if max_peak != 0 else peaks
#         peaks_all.append(np.array([normalized_peaks[0]]) if len(normalized_peaks) > 1 else normalized_peaks)
#         features_all.append(features[i])
#         indices_all.append(indices[i])
#     peaks_all = np.concatenate(peaks_all)
#     features_all = np.array(features_all)
#     indices_all = np.array(indices_all)
    
#     return peaks_all, features_all, indices_all


# def scalarizer_cumulative_peak(targets, features, indices):
#     peaks_all, features_all, indices_all = [], [], []
#     for i, t in enumerate(targets):
#         peaks = find_peaks(t, width=5)[1]["prominences"]
#         if len(peaks) == 0:
#             continue
#         cumulative_peaks = np.cumsum(peaks)
#         peaks_all.append(np.array([cumulative_peaks[0]]) if len(cumulative_peaks) > 1 else cumulative_peaks)
#         features_all.append(features[i])
#         indices_all.append(indices[i])
#     peaks_all = np.concatenate(peaks_all)
#     features_all = np.array(features_all)
#     indices_all = np.array(indices_all)
    
#     return peaks_all, features_all, indices_all

# def scalarizer_log_peak(targets, features, indices):
#     peaks_all, features_all, indices_all = [], [], []
#     for i, t in enumerate(targets):
#         peaks = find_peaks(t, width=5)[1]["prominences"]
#         if len(peaks) == 0:
#             continue
#         log_peaks = np.log(peaks + 1e-6)  # Adding a small constant to avoid log(0)
#         peaks_all.append(np.array([log_peaks[0]]) if len(log_peaks) > 1 else log_peaks)
#         features_all.append(features[i])
#         indices_all.append(indices[i])
#     peaks_all = np.concatenate(peaks_all)
#     features_all = np.array(features_all)
#     indices_all = np.array(indices_all)
    
#     return peaks_all, features_all, indices_all
