#!/bin/bash
METHOD=transfer_ot
MAP=cla
N_SAMPLES=200
RETRAIN=120
DECAY=2
DECAY_FACTOR=2.0
DECAY_EPOCHS=20_40_60_80_100
for seed in {42..42}
do
    echo "----- seed = $seed"
    DATA_PATH=./resnet34_resnet18_${METHOD}_${MAP}/seed_$seed
    python retrain_from_checkpoints.py --gpu-id 1 --num-models 1 --model-name resnet34_nobias_nobn --save-result-file ${METHOD}_$seed.csv --recheck-cifar --load-models $DATA_PATH --ckpt-type best --dataset Cifar10 --retrain $RETRAIN --retrain-lr-decay $DECAY --retrain-lr-decay-factor $DECAY_FACTOR --retrain-lr-decay-epochs $DECAY_EPOCHS --dump-final-models
done
