import os

import colormaps
import matplotlib.pyplot as plt

try:
    plt.style.use('.matplotlibrc')
except:
    pass

cmap = colormaps.matter
prop_cycle = plt.rcParams['axes.prop_cycle']
colors = prop_cycle.by_key()['color']
eta_cmap = "rocket_r"

# FILES
necessary_folders = [
    "results",
    "results/figures/",
    "results/figures/eta",
    "results/figures/exploration",
    "results/figures/analysis",
    "results/figures/article",
    "results/figures/one_example",

]
for f in necessary_folders:
    if not os.path.exists(f):
        os.makedirs(f)

# CONSTANT (old constant)
c = 0.5
c_prime = 0.1

# Parameter controlling the policy PAC(epsilon, delta)
delta = 0.01  # confidence level previous val 0.05
epsilon = 0.05  # Margin error

epsilon_d_tracking = 0.1
delta_d_tracking = 0.5

# MESSY RANK Parameter
epsilon_messy_rank = 1
parameter_messy_rank = 1
local_delta = False
