import matplotlib.pyplot as plt

from active_ranking.experiments.experiment import Experiment, models
from active_ranking.scenarios import inputs

if __name__ == '__main__':
    figure_args = dict(figsize=(3.5, 3.5), dpi=250)
    from active_ranking.experiments.plotting import plot, plot_lines

    for k in inputs.__dict__.keys():
        if "scenario" in k:

            name = str(k)
            n_exp = 100
            experiments = [Experiment(m, n_exp, name) for m in models]
            for exp in experiments:
                exp.run_or_load()

            plt.figure(**figure_args)
            for exp in experiments:
                plot(exp, metric="inf_norm", kwargs_fill={"alpha": 0.2},
                     kwargs_plot={"label": f"$d_\infty$ {exp.method.name}"})

            plt.ylabel("1 - $\\varepsilon$")
            plt.xlabel("$t$")
            plt.legend()
            plt.savefig(f"results/figures/analysis/"
                        f"regret_dinf/{name}_dinf_regret")

            plt.figure(**figure_args)
            for exp in experiments:
                plot(exp, metric="one_norm", kwargs_fill={"alpha": 0.2},
                     kwargs_plot={"label": f"$d_1$ {exp.method.name}"})
            plt.ylabel("1 - $\\varepsilon$")
            plt.xlabel("$t$")
            plt.legend()
            plt.savefig(f"results/figures/analysis/regret_d1/"
                        f"{name}_d1_regret")

            plt.figure(**figure_args)
            for exp in experiments:
                plot_lines(exp, metric="inf_norm", kwargs_fill={"alpha": 0.2},
                           kwargs_plot={
                               "label": f"$d_\infty$ {exp.method.name}"})
            plt.legend()
            plt.xlabel("$1 - \\varepsilon$")
            plt.ylabel("$t$")
            plt.savefig(f"results/figures/analysis/regret_dinf_2/"
                        f"/{name}_dinf_regret2")
