import datetime
import time
from functools import wraps

__cached_time__ = {}
__cached_time_n_call__ = {}


class ColorsOut:
    HEADER = '\033[95m'
    OKBLUE = '\033[94m'
    OKGREEN = '\033[92m'
    WARNING = '\033[93m'
    FAIL = '\033[91m'
    ENDC = '\033[0m'
    BOLD = '\033[1m'
    UNDERLINE = '\033[4m'
    Red = '\033[91m'
    Green = '\033[92m'
    Blue = '\033[94m'
    Cyan = '\033[96m'
    White = '\033[97m'
    Yellow = '\033[93m'
    Magenta = '\033[95m'
    Grey = '\033[90m'
    Black = '\033[90m'
    Default = '\033[99m'
    DEFAULT = Blue
    TIME = Grey


def print_(output, color="DEFAULT"):
    print(
        f"""{ColorsOut.__getattribute__(ColorsOut, color)}{output}{ColorsOut.ENDC}""")


def execution_time(method):
    @wraps(method)
    def timed(*args, **kw):
        ts = time.time()
        res = method(*args, **kw)
        te = time.time()
        if method.__name__ not in __cached_time__.keys():
            __cached_time__[method.__name__] = te - ts
            __cached_time_n_call__[method.__name__] = 1
        else:
            __cached_time__[method.__name__] += te - ts
            __cached_time_n_call__[method.__name__] += 1
        space = "-" * (40 - len(method.__name__))
        time_ = str(datetime.timedelta(milliseconds=(te - ts) * 1000))
        sum_time = str(datetime.timedelta(
            milliseconds=(__cached_time__[method.__name__]) * 1000))
        msg = f"[{method.__name__}] execution time : {space} {time_} {sum_time}"

        if hasattr(args[0], "active_execution_time"):
            if not args[0].active_execution_time:
                return res
            else:
                print_(msg, color="TIME")
        else:
            print_(msg, color="TIME")
        return res

    return timed
